

function [R,i] = ModIteracija(E,M,m,inter)

% Ovde se resenja traze modifikovanom iterativnom metodom, gde su:
% E - zadata tacnost
% M - maksimum prvog izvoda funkcije na intervalu inter
% m - minimum prvog izvoda funkcije na intervalu inter
% R - resenje
% i - broj iteracija potrebnih za dobijanje resenja

% Pomocna funkcija se dobija kao F(x)=x - L.*f(x), pa se mora prvo naci L:
L=2./(M+m);

% Pomocna funkcija F(x) ce biti
F='x-L.*(4.*exp(x)-5.*(x+1))';

% q (potrebno za kriterijum zaustavljanja) ce biti
q=(M-m)./(M+m);

% a kriterijum zaustavljanja ce biti
kz=abs((1-q)./q.*E);

% Za pocetnu tacku y(1) cemo proglasiti tacku 
y(1)=(inter(1) + inter(2))./2;
i=1;
x=y(1);

% a zatim cemo traziti vrednosti y(i+1)=F(y(i)), sve dok ne postane 
% abs(y(i)-y(i-1)) manje ili jednako od kz 
y(i+1)=eval(F);
i=i+1;
while abs(y(i)-y(i-1)) > kz
      x=y(i);
      i=i+1;
      y(i)=eval(F);
end

% Poslednje dobijeno resenje y(i) je priblizno resenje nase jednacine
R=y(i);